VERSION 5.00
Begin VB.UserControl ArmPicker 
   ClientHeight    =   765
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   765
   ScaleWidth      =   4800
   Begin VB.CommandButton cmd_Pick 
      Caption         =   "..."
      Height          =   345
      Left            =   3750
      TabIndex        =   1
      Top             =   180
      Width           =   360
   End
   Begin VB.TextBox txt_Desc 
      Height          =   360
      Left            =   165
      TabIndex        =   0
      Top             =   165
      Width           =   3390
   End
End
Attribute VB_Name = "ArmPicker"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'armsyscom instance
#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private mb_Locked As Boolean
Private ml_LocalID As Long
Private ml_CodePage As Long

Private ms_ItemCode As String

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_LOCKED As Long = &H80000018
Private Const SEP = ""
Const C_ERRORRAISE As Long = 2500

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Public Event ItemPicked()

Public Function Load_A_Com() As Boolean

    Locked = True
    
End Function

Public Function UnLoad_A_Com() As Boolean

End Function
'main ArmSysCom object, if you pass this property, object should be connected to db
'when calling Execute or Load
Public Property Set ArmDb(ByVal lo_Db As ARMSYSCOMLib.ArmDb)
  
  'do not accept external instance of ArmDb when already internal instance exists
  Set mo_Db = lo_Db
End Property

Public Property Get ArmDb() As ARMSYSCOMLib.ArmDb
#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(True, "ArmGrid:ArmDB_Get")
#End If
  
  Set ArmDb = mo_Db

#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(False, "ArmGrid:ArmDB_Get")
#End If
End Property

Property Let LocalID(al_Value As Long)
  
#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(True, "ArmGrid:LocalID_Let")
#End If
  
  ml_LocalID = al_Value

#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(False, "ArmGrid:LocalID_Let")
#End If
End Property

Property Get LocalID() As Long
  
#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(True, "ArmGrid:LocalID_Get")
#End If
  
  LocalID = ml_LocalID

#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(False, "ArmGrid:LocalID_Get")
#End If
End Property

Property Let Codepage(al_Value As Long)
  
  ml_CodePage = al_Value
End Property

Property Get Codepage() As Long
  
  Codepage = ml_CodePage
End Property

Property Let MaxLength(al_Value As Long)
  
  txt_Desc.MaxLength = al_Value
End Property

Property Get MaxLength() As Long
  
  MaxLength = txt_Desc.MaxLength
End Property

Property Let ItemCode(as_Value As String)
  
  ms_ItemCode = as_Value
End Property

Property Get ItemCode() As String
  
  ItemCode = ms_ItemCode
End Property

Property Let ItemDescription(as_Value As String)
  
  txt_Desc.Text = as_Value
End Property

Property Get ItemDescription() As String
  
  ItemDescription = txt_Desc.Text
End Property

Private Sub LockDesc(ByVal ab_Locked As Boolean)

  If ab_Locked Then
    txt_Desc.Locked = True
    txt_Desc.BackColor = CL_COLOR_LOCKED
  Else
    txt_Desc.Locked = False
    txt_Desc.BackColor = CL_COLOR_ENABLED
  End If
End Sub

Property Let Locked(ab_Value As Boolean)
  
  mb_Locked = ab_Value
  Call LockDesc(ab_Value)
End Property

Property Get Locked() As Boolean
  
  Locked = mb_Locked
End Property

Property Let Enabled(ab_Value As Boolean)
  
  cmd_Pick.Enabled = ab_Value
  If ab_Value Then
    Call LockDesc(mb_Locked)
  Else
    Call LockDesc(True)
  End If
End Property

Property Get Enabled() As Boolean
  
  Enabled = cmd_Pick.Enabled
End Property

Public Property Let Visible(ByVal aValue As Boolean)
    UserControl.Extender.Visible = aValue
End Property

Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Property Get Font() As StdFont

  Set Font = txt_Desc.Font
End Property

Public Sub Clear()
    ItemCode = ""
    ItemDescription = ""
End Sub

Private Sub cmd_Pick_Click()
    RaiseEvent ItemPicked
End Sub

Private Sub UserControl_Resize()
    Call txt_Desc.Move(0, 0, IIf(UserControl.Width - cmd_Pick.Width > 0, UserControl.Width - cmd_Pick.Width, 0), UserControl.Height)
    Call cmd_Pick.Move(IIf(UserControl.Width - cmd_Pick.Width > 0, UserControl.Width - cmd_Pick.Width, 0), 0, cmd_Pick.Width, UserControl.Height)
    Call cmd_Pick.ZOrder
End Sub
